# ADOBE CONFIDENTIAL
#
# Copyright 2010-2022 Adobe
# All Rights Reserved.
#
# NOTICE:  Adobe permits you to use, modify, and distribute this file in
# accordance with the terms of the Adobe license agreement accompanying it.
# If you have received this file from a source other than Adobe,
# then your use, modification, or distribution of it requires the prior
# written permission of Adobe.
#
# Autogenerated by ipa. Don't edit directly, edit the definitions and regenerate it when changing
#

from __future__ import annotations

import ctypes
import base64

from typing import Any, Optional

from .sdarray import *
from .sddefinition import *
from .sdnode import *
from .sdresource import *
from .sdgraphobject import *
from .sdapiobject import *
from .sdresource import *
from .sdapiobject import *
from .apiexception import APIException

class SDGraph(SDResource):
    """
    Base class of all graphs
    """
    def __init__(self, APIContext, handle, *args, **kwargs):
        """
        Constructor

        :rtype: SDGraph
        """
        super(SDGraph, self).__init__(APIContext, handle, *args, **kwargs)

    def getNodeDefinitions(self) -> SDArray[SDDefinition]:
        """
        Get all available node definitions for this type of graph

        """
        outArray = ctypes.c_void_p()
        _res = self.mAPIContext.SDGraph_getNodeDefinitions(self.mHandle, ctypes.byref(outArray))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        constructor = self.mAPIContext.mTypeMap[SDAPIObject(self.mAPIContext, outArray, ownHandle=False).getClassName()]
        return constructor(self.mAPIContext, outArray.value, ownHandle=True)

    def newNode(self, sdDefinitionId : str) -> Optional[SDNode]:
        """
        Create a new node

        :param sdDefinitionId: The identifier of the SDDefinition of the node to create
        """
        outNode = ctypes.c_void_p()
        _res = self.mAPIContext.SDGraph_newNode(self.mHandle, ctypes.create_string_buffer(sdDefinitionId.encode('utf-8')), ctypes.byref(outNode))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        constructor = self.mAPIContext.mTypeMap[SDAPIObject(self.mAPIContext, outNode, ownHandle=False).getClassName()]
        return constructor(self.mAPIContext, outNode.value, ownHandle=True)

    def newInstanceNode(self, sdResourceToInstantiate : SDResource) -> Optional[SDNode]:
        """
        Create a new instance node from the specified resource

        :param sdResourceToInstantiate: The resource to instantiate
        """
        outNode = ctypes.c_void_p()
        _res = self.mAPIContext.SDGraph_newInstanceNode(self.mHandle, sdResourceToInstantiate.mHandle, ctypes.byref(outNode))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        constructor = self.mAPIContext.mTypeMap[SDAPIObject(self.mAPIContext, outNode, ownHandle=False).getClassName()]
        return constructor(self.mAPIContext, outNode.value, ownHandle=True)

    def deleteNode(self, sdNode : SDNode) -> None:
        """
        Delete the specified node

        :param sdNode: The node to delete
        """
        _res = self.mAPIContext.SDGraph_deleteNode(self.mHandle, sdNode.mHandle)
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        return None

    def getNodes(self) -> SDArray[SDNode]:
        """
        Get all nodes of this graph

        """
        outArray = ctypes.c_void_p()
        _res = self.mAPIContext.SDGraph_getNodes(self.mHandle, ctypes.byref(outArray))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        constructor = self.mAPIContext.mTypeMap[SDAPIObject(self.mAPIContext, outArray, ownHandle=False).getClassName()]
        return constructor(self.mAPIContext, outArray.value, ownHandle=True)

    def getNodeFromId(self, sdNodeId : str) -> Optional[SDNode]:
        """
        Get the node that matches the specified identifier

        :param sdNodeId: The node identifier
        """
        outSDNode = ctypes.c_void_p()
        _res = self.mAPIContext.SDGraph_getNodeFromId(self.mHandle, ctypes.create_string_buffer(sdNodeId.encode('utf-8')), ctypes.byref(outSDNode))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        constructor = self.mAPIContext.mTypeMap[SDAPIObject(self.mAPIContext, outSDNode, ownHandle=False).getClassName()]
        return constructor(self.mAPIContext, outSDNode.value, ownHandle=True)

    def getOutputNodes(self) -> SDArray[SDNode]:
        """
        Get the list of all output nodes of the graph

        """
        outArray = ctypes.c_void_p()
        _res = self.mAPIContext.SDGraph_getOutputNodes(self.mHandle, ctypes.byref(outArray))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        constructor = self.mAPIContext.mTypeMap[SDAPIObject(self.mAPIContext, outArray, ownHandle=False).getClassName()]
        return constructor(self.mAPIContext, outArray.value, ownHandle=True)

    def setOutputNode(self, sdNode : SDNode, isOutput : bool) -> None:
        """
        Set/Unset the specified node as an output node of the graph

        :param sdNode: The node to set/unset as an output node
        :param isOutput: Indicates whether the specified node is an output node
        """
        _res = self.mAPIContext.SDGraph_setOutputNode(self.mHandle, sdNode.mHandle, isOutput)
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        return None

    def getGraphObjects(self) -> SDArray[SDGraphObject]:
        """
        Get all SDGraphObject of the graph

        """
        outArray = ctypes.c_void_p()
        _res = self.mAPIContext.SDGraph_getGraphObjects(self.mHandle, ctypes.byref(outArray))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        constructor = self.mAPIContext.mTypeMap[SDAPIObject(self.mAPIContext, outArray, ownHandle=False).getClassName()]
        return constructor(self.mAPIContext, outArray.value, ownHandle=True)

    def deleteGraphObject(self, sdGraphObj : SDGraphObject) -> None:
        """
        Delete the specified graph object

        :param sdGraphObj: The graph object to delete
        """
        _res = self.mAPIContext.SDGraph_deleteGraphObject(self.mHandle, sdGraphObj.mHandle)
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        return None

